/*
 * wrapper.c
 *
 *  Created on: 11.11.2013
 *  Changed on: 18.09.2023
 */

#include "wrapper.h"

void sleep(U32 ms)
{
    __asm __volatile("mov r0, %0\n"
                     "svc 0xe1\n"
                     :
                     : "r"(ms)
                     : "r0");
}

void yield(void)
{
    sleep(1);
}

void __attribute__((section(".boot"))) __attribute__((naked)) start()
{
    while (1)
    {
        user();
        sleep(1);
    }
}

// floating point support
float __aeabi_fmul(float a, float b)
{
    float result;

    __asm __volatile("mov r0, %1\n"
                     "mov r1, %2\n"
                     "svc 0x01\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a), "r"(b)
                     : "r0", "r1");

    return result;
}

float __aeabi_fdiv(float a, float b)
{
    float result;

    __asm __volatile("mov r0, %1\n"
                     "mov r1, %2\n"
                     "svc 0x02\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a), "r"(b)
                     : "r0", "r1");

    return result;
}

float __aeabi_fadd(float a, float b)
{
    float result;

    __asm __volatile("mov r0, %1\n"
                     "mov r1, %2\n"
                     "svc 0x03\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a), "r"(b)
                     : "r0", "r1");

    return result;
}

float __aeabi_fsub(float a, float b)
{
    float result;

    __asm __volatile("mov r0, %1\n"
                     "mov r1, %2\n"
                     "svc 0x04\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a), "r"(b)
                     : "r0", "r1");

    return result;
}

S32 __aeabi_f2iz(float a)
{
    S32 result;

    __asm __volatile("mov r0, %1\n"
                     "svc 0x09\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a)
                     : "r0");

    return result;
}

float __aeabi_i2f(S32 a)
{
    float result;

    __asm __volatile("mov r0, %1\n"
                     "svc 0x0a\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a)
                     : "r0");

    return result;
}

float sqrt(float a)
{
    float result;

    __asm __volatile("mov r0, %1\n"
                     "svc 0x05\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a)
                     : "r0");

    return result;
}

float sin(float a)
{
    float result;

    __asm __volatile("mov r0, %1\n"
                     "svc 0x06\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a)
                     : "r0");

    return result;
}

float cos(float a)
{
    float result;

    __asm __volatile("mov r0, %1\n"
                     "svc 0x07\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a)
                     : "r0");

    return result;
}

float tan(float a)
{
    float result;

    __asm __volatile("mov r0, %1\n"
                     "svc 0x08\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a)
                     : "r0");

    return result;
}

float asin(float a)
{
    float result;

    __asm __volatile("mov r0, %1\n"
                     "svc 0x0b\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a)
                     : "r0");

    return result;
}

float acos(float a)
{
    float result;

    __asm __volatile("mov r0, %1\n"
                     "svc 0x0c\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a)
                     : "r0");

    return result;
}

float atan(float a)
{
    float result;

    __asm __volatile("mov r0, %1\n"
                     "svc 0x0d\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(a)
                     : "r0");

    return result;
}

void od_write(U32 index, U32 subindex, U32 value)
{
    __asm __volatile("mov r0, %0\n"
                     "mov r1, %1\n"
                     "mov r2, %2\n"
                     "svc 0x21\n"
                     :
                     : "r"(index), "r"(subindex), "r"(value)
                     : "r0", "r1", "r2");
}

U32 od_read(U32 index, U32 subindex)
{
    U32 result;

    __asm __volatile("mov r0, %1\n"
                     "mov r1, %2\n"
                     "svc 0x20\n"
                     "mov %0,r0"
                     : "=r"(result)
                     : "r"(index), "r"(subindex)
                     : "r0", "r1");

    return result;
}

////////////////////////////////////////////////////
// debug output string

bool VmmDebugOutputString(const char* outstring)
{
    U32 result;

    while (1)
    {
        __asm __volatile("mov r0, %1\n"
                         "svc 0xD0\n"
                         "mov %0,r0"
                         : "=r"(result)
                         : "r"(outstring)
                         : "r0");

        if ((result & VMM_DEBUG_OUTPUT_OVERFLOW) == 0)
            break;

        sleep(0);
    }

    return result == 0;
}

////////////////////////////////////////////////////
// debug output int

bool VmmDebugOutputInt(const U32 val)
{
    U32 result;

    while (1)
    {
        __asm __volatile("mov r0, %1\n"
                         "svc 0xD1\n"
                         "mov %0,r0"
                         : "=r"(result)
                         : "r"(val)
                         : "r0");

        if ((result & VMM_DEBUG_OUTPUT_OVERFLOW) == 0)
            break;

        sleep(0);
    }

    return result == 0;
}

////////////////////////////////////////////////////
// debug output byte

bool VmmDebugOutputByte(const U08 val)
{
    U32 result;

    while (1)
    {
        __asm __volatile("mov r0, %1\n"
                         "svc 0xD2\n"
                         "mov %0,r0"
                         : "=r"(result)
                         : "r"(val)
                         : "r0");

        if ((result & VMM_DEBUG_OUTPUT_OVERFLOW) == 0)
            break;

        sleep(0);
    }
    return result == 0;
}

////////////////////////////////////////////////////
// debug output half word

bool VmmDebugOutputHalfWord(const U16 val)
{
    U32 result;

    while (1)
    {
        __asm __volatile("mov r0, %1\n"
                         "svc 0xD3\n"
                         "mov %0,r0"
                         : "=r"(result)
                         : "r"(val)
                         : "r0");

        if ((result & VMM_DEBUG_OUTPUT_OVERFLOW) == 0)
            break;

        sleep(0);
    }

    return result;
}

////////////////////////////////////////////////////
// debug output word

bool VmmDebugOutputWord(const U32 val)
{
    U32 result;
    while (1)
    {
        __asm __volatile("mov r0, %1\n"
                         "svc 0xD4\n"
                         "mov %0,r0"
                         : "=r"(result)
                         : "r"(val)
                         : "r0");

        if ((result & VMM_DEBUG_OUTPUT_OVERFLOW) == 0)
            break;

        sleep(0);
    }
    return result == 0;
}

////////////////////////////////////////////////////
// debug output float

bool VmmDebugOutputFloat(const float val)
{
    U32 result;

    while (1)
    {
        __asm __volatile("mov r0, %1\n"
                         "svc 0xD5\n"
                         "mov %0,r0"
                         : "=r"(result)
                         : "r"(val)
                         : "r0");

        if ((result & VMM_DEBUG_OUTPUT_OVERFLOW) == 0)
            break;

        sleep(0);
    }

    return result == 0;
}
